IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP')
BEGIN
	CREATE TABLE [dbo].[EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_USU] [int] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
	 CONSTRAINT [PK_EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP] ADD  CONSTRAINT [DF_EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

	ALTER TABLE [dbo].[EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
	REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

	ALTER TABLE [dbo].[EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP] CHECK CONSTRAINT [FK_EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP_EST_NF_SAI]

	ALTER TABLE [dbo].[EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP_GLB_USU] FOREIGN KEY([CD_USU])
	REFERENCES [dbo].[GLB_USU] ([CD_USU])

	ALTER TABLE [dbo].[EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP] CHECK CONSTRAINT [FK_EST_NF_SAI_CHECKIN_ENTRADA_DIVERGENTE_TMP_GLB_USU]
END